import sys

def list_eq(a, b):
    if len(a) != len(b):
        return False
    sorted_a, sorted_b = sorted(a), sorted(b)
    return all(x == y for x, y in zip(sorted_a, sorted_b))

def keep_digits(s):
    return s.replace('+', ' ').replace('-', ' ').replace('*', ' ').replace('/', ' ')\
            .replace('(', ' ').replace(')', ' ')

with open('user_out', 'r') as f:
    user_out = f.read().strip()

# user_out should no longer than 100 characters
if len(user_out) > 100:
    print("user_out is too long", file=sys.stderr)
    print(0)
    exit(0)

# print user_out for debugging
print("user_out:", "<empty>" if not user_out else user_out, file=sys.stderr)

# user_out should only contain digits, +, -, *, /, (, )
if not all(c in '0123456789+-*/()' for c in user_out):
    print("user_out contains invalid characters", file=sys.stderr)
    print(0)
    exit(0)

# user_out should not container ** or //
if '**' in user_out or '//' in user_out:
    print("user_out contains invalid operators ** or //", file=sys.stderr)
    print(0)
    exit(0)

with open('input', 'r') as f:
    std_nums = list(map(int, f.read().strip().split()))

user_nums = list(map(int, keep_digits(user_out).split()))

# user_out should only contain numbers in input
if not list_eq(std_nums, user_nums):
    print("user_out not using exactly the numbers in input", file=sys.stderr)
    print("expected:", std_nums, file=sys.stderr)
    print("got:", user_nums, file=sys.stderr)
    print(0)
    exit(0)

# replace / with // for integer division
user_out = user_out.replace('/', '//')

try:
    result = eval(user_out)
    if result == 24:
        print("ok", file=sys.stderr)
        print(100)
    else:
        print("result is not 24", file=sys.stderr)
        print(0)
except Exception as e:
    print("error occurred during evaluation:", e, file=sys.stderr)
    print(0)