#include <iostream>
#include <fstream>
#include <string>
#include <regex>

const int N = 305;

int n, m;
int status[N][N]; // 0: down, 1: up, 2: removed
std::string s[N][N];

std::ofstream score;
std::ifstream input;

void print_status() {
    std::cerr << "Status:" << std::endl;
    std::cerr << "*******" << std::endl;
    for (int i = 1; i <= n; ++i) {
        for (int j = 1; j <= m; ++j) {
            std::cerr << status[i][j] << ' ';
        }
        std::cerr << std::endl;
    }
}

std::pair<int, int> get_query() {
    std::string line;
    std::getline(std::cin, line);
    // line = "? 1 1";
    std::regex re("\\? (\\d+) (\\d+)");
    std::smatch match;
    std::regex_match(line, match, re);
    if (match.size() != 3) {
        std::cerr << "Your operation is incorrect format: " << line <<std::endl;
        score << "0" << std::endl;
        exit(0);
    }
    int x = std::stoi(match[1]);
    int y = std::stoi(match[2]);
    if (x < 1 || x > n || y < 1 || y > m) {
        std::cerr << "Your operation is out of range: "<<line<< std::endl;
        score << "0" << std::endl;
        exit(0);
    }
    if (status[x][y] == 2) {
        std::cerr << "The card is already been removed: "<<line<< std::endl;
        //print_status();
        score << "0" << std::endl;
        exit(0);
    }
    if (status[x][y] == 1) {
        std::cerr << "The card is already up: " <<line<< std::endl;
        //print_status();
        score << "0" << std::endl;
        exit(0);
    }
    return {x, y};
}

int main() {
	std::ios::sync_with_stdio(false);
    score.open("score.txt");
    input.open("input");
    input >> n >> m;
    for (int i = 1; i <= n; ++i)
        for (int j = 1; j <= m; ++j)
            input >> s[i][j];
    std::cout << n << ' ' << m << std::endl;
    int remain = n * m;
    int queries = 0;
    std::string last;
    int last_x, last_y;
    while (true) {
        auto [x, y] = get_query();
        ++queries;
        if (queries >= 2 * n * m) {
            std::cerr << "Too many queries!" << std::endl;
            score << "0" << std::endl;
            exit(0);
        }
        status[x][y] = 1;

        if (queries % 2 == 1) {
            last = s[x][y];
            last_x = x;
            last_y = y;
        } else {
            if (last == s[x][y]) {
                status[last_x][last_y] = 2;
                status[x][y] = 2;
                remain -= 2;
            } else {
                status[last_x][last_y] = 0;
                status[x][y] = 0;
            }
            last = "";
        }

        if (remain == 0) {
            std::cerr << "Accepted." << std::endl;
            std::cout << "Accepted." << std::endl;
            score << "100" << std::endl;
            exit(0);
        }

        std::cout << s[x][y] << std::endl;
    }

    return 0;
}
