#include "testlib.h"
#include <bits/stdc++.h>

using namespace std;

const int N = 32000 + 10;
const int M = 3e6 + 10;

pair<int, int> b[M];
int d[N];
int f[N];
int cnt[N];
int F(int x) {
    return x == f[x] ? x : f[x] = F(f[x]);
}

int main(int argc, char* argv[]) {
    registerTestlibCmd(argc, argv);

    int n = inf.readInt();
    int vertexSize = n * (n + 1) / 2;
    int edgeSize = 1ll * n * (n + 1) * (2 * n + 1) / 12;

    iota(f + 1, f + 1 + vertexSize, 1);
    for (int i = 0; i < edgeSize; ++i) {
        int u = ouf.readInt(1, vertexSize);
        int v = ouf.readInt(1, vertexSize);
        if (u == v) {
            quitf(_wa, "A self-loop is found.");
        }
        if (u > v)
            swap(u, v);
        b[i] = {u, v};
        ++d[u];
        ++d[v];
        f[F(u)] = F(v);
    }
    sort(b, b + edgeSize, [] (auto A, auto B) {
        if (A.first == B.first) {
            return A.second < B.second;
        }
        return A.first < B.first;
    });
    for (int i = 1; i < edgeSize; ++i) {
        if (b[i - 1].first == b[i].first && b[i - 1].second == b[i].second) {
            quitf(_wa, "Multiple edges are found.");
        }
    }
    for (int i = 2, j = F(1); i <= vertexSize; ++i) {
        if (F(i) != j) {
            quitf(_wa, "The graph is not connected.");
        }
    }
    for (int i = 1; i <= vertexSize; ++i) {
        if (d[i] < 1 || d[i] > n) {
            quitf(_wa, "Vertex %d's degree is exceeded", i);
        }
        ++cnt[d[i]];
//        cerr << i << ' ' << d[i] << endl;
    }
    for (int i = 1; i <= n; ++i) {
        if (cnt[i] != i) {
            quitf(_wa, "The number of vertex whose degree is equal to %d is not %d.", i, i);
        }
    }

    quitf(_ok, "The answer is correct.");

    return 0;
}
