#include <stdio.h>
#include <math.h>
#include <cstring>
#include <stdlib.h>
const double EPS = 1E-6;

#ifdef __GNUC__
#    define __TESTLIB_STATIC_ASSERT(condition) typedef void* __testlib_static_assert_type[(condition) ? 1 : -1] __attribute__((unused))
#else
#    define __TESTLIB_STATIC_ASSERT(condition) typedef void* __testlib_static_assert_type[(condition) ? 1 : -1]
#endif

template<typename T>
static inline T __testlib_abs(const T& x)
{
    return x > 0 ? x : -x;
}

template<typename T>
static inline T __testlib_min(const T& a, const T& b)
{
    return a < b ? a : b;
}

template<typename T>
static inline T __testlib_max(const T& a, const T& b)
{
    return a > b ? a : b;
}

static bool __testlib_prelimIsNaN(double r)
{
    volatile double ra = r;
#ifndef __BORLANDC__
    return ((ra != ra) == true) && ((ra == ra) == false) && ((1.0 > ra) == false) && ((1.0 < ra) == false);
#else
    return std::_isnan(ra);
#endif
}

static bool __testlib_isNaN(double r)
{
    __TESTLIB_STATIC_ASSERT(sizeof(double) == sizeof(long long));
    volatile double ra = r;
    long long llr1, llr2;
    std::memcpy((void*)&llr1, (void*)&ra, sizeof(double)); 
    ra = -ra;
    std::memcpy((void*)&llr2, (void*)&ra, sizeof(double)); 
    long long llnan = 0xFFF8000000000000;
    return __testlib_prelimIsNaN(r) || llnan == llr1 || llnan == llr2;
}

static bool __testlib_isInfinite(double r)
{
    volatile double ra = r;
    return (ra > 1E300 || ra < -1E300);
}

#define _wa 0
#define _ok 100

#define quitf(score, ...) (printf("%d",score),fprintf(stderr,__VA_ARGS__),exit(0))
char a[100],b[100];
int cnt[10000],g[100][100];
int main()
{
	FILE*fin=fopen("input","r");
	FILE*fuser=fopen("user_out","r");
	FILE*fans=fopen("answer","r");
	int T;
	fscanf(fin,"%d",&T);
	for(int t=1;t<=T;t++){
		int n;
		fscanf(fin,"%d",&n);
		fscanf(fuser,"%s",a);
		fscanf(fans,"%s",b);
//		printf("%s %s\n",a,b);
		if(a[0]!=b[0]||a[1]!=b[1]||a[2]!=b[2])
			quitf(_wa,"in Test%d: Wrong Ansewer",t);
		if(a[0]=='N'){
			int x;
			for(int i=1;i<=n*n;i++)
				fscanf(fin,"%d",&x);
				continue;
		}
		for(int i=1;i<=n;i++)
		for(int j=1;j<=n;j++){
			int x;
			fscanf(fin,"%d",&x);
			cnt[x]++;
			fscanf(fuser,"%d",&g[i][j]);
			if(g[i][j]<0)quitf(_wa,"in Test%d: g[%d][%d] is too small",t,i,j);
			if(g[i][j]>1000)quitf(_wa,"in Test%d: g[%d][%d] is too large",t,i,j);
			cnt[g[i][j]]--;
		}
		for(int i=1;i<=1000;i++)
			if(cnt[i])quitf(_wa,"in Test%d: Numbers are changed",t);
		bool ok = 1;
		for(int i=1;i<=n;i++){
			for(int j=1;j<=n;j++){
				if(g[i][j]!=g[i][n-j+1])ok = 0;
				if(g[i][j]!=g[n-i+1][j])ok = 0;
			}
		}
		if(!ok)quitf(_wa,"in Test%d: Matrix is not palindromic",t);
	}
	quitf(_ok, "");
}
