#include <stdio.h>
#include <math.h>
#include <cstring>
#include <stdlib.h>
const double EPS = 1E-6;

#ifdef __GNUC__
#    define __TESTLIB_STATIC_ASSERT(condition) typedef void* __testlib_static_assert_type[(condition) ? 1 : -1] __attribute__((unused))
#else
#    define __TESTLIB_STATIC_ASSERT(condition) typedef void* __testlib_static_assert_type[(condition) ? 1 : -1]
#endif

template<typename T>
static inline T __testlib_abs(const T& x)
{
    return x > 0 ? x : -x;
}

template<typename T>
static inline T __testlib_min(const T& a, const T& b)
{
    return a < b ? a : b;
}

template<typename T>
static inline T __testlib_max(const T& a, const T& b)
{
    return a > b ? a : b;
}

static bool __testlib_prelimIsNaN(double r)
{
    volatile double ra = r;
#ifndef __BORLANDC__
    return ((ra != ra) == true) && ((ra == ra) == false) && ((1.0 > ra) == false) && ((1.0 < ra) == false);
#else
    return std::_isnan(ra);
#endif
}

static bool __testlib_isNaN(double r)
{
    __TESTLIB_STATIC_ASSERT(sizeof(double) == sizeof(long long));
    volatile double ra = r;
    long long llr1, llr2;
    std::memcpy((void*)&llr1, (void*)&ra, sizeof(double)); 
    ra = -ra;
    std::memcpy((void*)&llr2, (void*)&ra, sizeof(double)); 
    long long llnan = 0xFFF8000000000000;
    return __testlib_prelimIsNaN(r) || llnan == llr1 || llnan == llr2;
}

static bool __testlib_isInfinite(double r)
{
    volatile double ra = r;
    return (ra > 1E300 || ra < -1E300);
}

#define _wa 0
#define _ok 100

#define quitf(score, ...) (printf("%d",score),fprintf(stderr,__VA_ARGS__),exit(0))
int d[200][200],g[200][200],n,m;
inline bool check(int x){
	if(x<0||x>n)return 0;
	return 1;
}
int main()
{
	FILE*fin=fopen("input","r");
	fscanf(fin,"%d",&n);
	for(int i=1;i<=n;i++)
	for(int j=1;j<=n;j++)
	fscanf(fin,"%d",&d[i][j]);
	FILE*fuser=fopen("user_out","r");
	FILE*fans=fopen("answer","r");
	int ans;fscanf(fans,"%d",&ans);
	fscanf(fuser,"%d",&m);
	if(m>ans)quitf(_wa,"Too many edges");
	for(int i=1;i<=n;i++)
	for(int j=1;j<=n;j++)
	g[i][j] = i==j; 
	for(int i=1;i<=m;i++){
		int x,y;
		fscanf(fuser,"%d%d",&x,&y);
		if(!check(x)||!check(y))
			quitf(_wa,"Output doesn't meet the requirements");
		g[x][y] = g[y][x] = 1;
	}
	for(int k=1;k<=n;k++)
	for(int i=1;i<=n;i++)
	for(int j=1;j<=n;j++)
		g[i][j] |= g[i][k]&g[k][j];
	for(int i=1;i<=n;i++)
	for(int j=1;j<=n;j++){
		if(g[i][j]!=d[i][j]){
			quitf(_wa,"d[%d][%d] is changed",i,j);
		}
	} 
	fclose(fin);fclose(fuser);fclose(fans);
    quitf(_ok, "");
}
