#include <stdio.h>
#include <math.h>
#include <cstring>
#include <stdlib.h>

const double EPS = 1E-6;

#ifdef __GNUC__
#    define __TESTLIB_STATIC_ASSERT(condition) typedef void* __testlib_static_assert_type[(condition) ? 1 : -1] __attribute__((unused))
#else
#    define __TESTLIB_STATIC_ASSERT(condition) typedef void* __testlib_static_assert_type[(condition) ? 1 : -1]
#endif

template<typename T>
static inline T __testlib_abs(const T& x)
{
    return x > 0 ? x : -x;
}

template<typename T>
static inline T __testlib_min(const T& a, const T& b)
{
    return a < b ? a : b;
}

template<typename T>
static inline T __testlib_max(const T& a, const T& b)
{
    return a > b ? a : b;
}

static bool __testlib_prelimIsNaN(double r)
{
    volatile double ra = r;
#ifndef __BORLANDC__
    return ((ra != ra) == true) && ((ra == ra) == false) && ((1.0 > ra) == false) && ((1.0 < ra) == false);
#else
    return std::_isnan(ra);
#endif
}

static bool __testlib_isNaN(double r)
{
    __TESTLIB_STATIC_ASSERT(sizeof(double) == sizeof(long long));
    volatile double ra = r;
    long long llr1, llr2;
    std::memcpy((void*)&llr1, (void*)&ra, sizeof(double)); 
    ra = -ra;
    std::memcpy((void*)&llr2, (void*)&ra, sizeof(double)); 
    long long llnan = 0xFFF8000000000000;
    return __testlib_prelimIsNaN(r) || llnan == llr1 || llnan == llr2;
}

static bool __testlib_isInfinite(double r)
{
    volatile double ra = r;
    return (ra > 1E300 || ra < -1E300);
}

#define _wa 0
#define _ok 100

#define quitf(score, ...) (printf("%d",score),fprintf(stderr,__VA_ARGS__),exit(0))
int d[200][200],g[200][200];
int main()
{
	FILE*fin=fopen("input","r");
	int n;fscanf(fin,"%d",&n);
	for(int i=1;i<=n;i++)
	for(int j=1;j<=n;j++)
	fscanf(fin,"%d",&d[i][j]);
	FILE*fuser=fopen("user_out","r");
	for(int i=1;i<=n;i++)
	for(int j=1;j<=n;j++){
		fscanf(fuser,"%d",&g[i][j]);
		bool bad = 0;
		if(g[i][j]<=-2)bad = 1;
		if(i==j&&g[i][j])bad = 1;
		if(bad)quitf(_wa,"Output doesn't meet the requirements");
		if(g[i][j] == -1)g[i][j] = 1<<29;
	}
	for(int i=1;i<=n;i++)
	for(int j=1;j<=n;j++){
		if(g[i][j]!=g[j][i]){
			quitf(_wa,"Output doesn't meet the requirements");
		}
	}
	for(int k=1;k<=n;k++)
	for(int i=1;i<=n;i++)
	for(int j=1;j<=n;j++){
		int t = g[i][k]+g[k][j];
		if(t<g[i][j])g[i][j] = t;
	}
	for(int i=1;i<=n;i++)
	for(int j=1;j<=n;j++){
		if(g[i][j]!=d[i][j]){
			quitf(_wa,"The shortest paths are changed");
		}
	} 
	fclose(fin);fclose(fuser);
    quitf(_ok, "");
}
