#include <stdio.h>
#include <math.h>
#include <cstring>
#include <stdlib.h>

const double EPS = 1E-3;

#ifdef __GNUC__
#    define __TESTLIB_STATIC_ASSERT(condition) typedef void* __testlib_static_assert_type[(condition) ? 1 : -1] __attribute__((unused))
#else
#    define __TESTLIB_STATIC_ASSERT(condition) typedef void* __testlib_static_assert_type[(condition) ? 1 : -1]
#endif

template<typename T>
static inline T __testlib_abs(const T& x)
{
    return x > 0 ? x : -x;
}

template<typename T>
static inline T __testlib_min(const T& a, const T& b)
{
    return a < b ? a : b;
}

template<typename T>
static inline T __testlib_max(const T& a, const T& b)
{
    return a > b ? a : b;
}

static bool __testlib_prelimIsNaN(double r)
{
    volatile double ra = r;
#ifndef __BORLANDC__
    return ((ra != ra) == true) && ((ra == ra) == false) && ((1.0 > ra) == false) && ((1.0 < ra) == false);
#else
    return std::_isnan(ra);
#endif
}

static bool __testlib_isNaN(double r)
{
    __TESTLIB_STATIC_ASSERT(sizeof(double) == sizeof(long long));
    volatile double ra = r;
    long long llr1, llr2;
    std::memcpy((void*)&llr1, (void*)&ra, sizeof(double)); 
    ra = -ra;
    std::memcpy((void*)&llr2, (void*)&ra, sizeof(double)); 
    long long llnan = 0xFFF8000000000000;
    return __testlib_prelimIsNaN(r) || llnan == llr1 || llnan == llr2;
}

static bool __testlib_isInfinite(double r)
{
    volatile double ra = r;
    return (ra > 1E300 || ra < -1E300);
}

inline bool doubleCompare(double expected, double result, double MAX_DOUBLE_ERROR)
{
        if (__testlib_isNaN(expected))
        {
            return __testlib_isNaN(result);
        }
        else 
            if (__testlib_isInfinite(expected))
            {
                if (expected > 0)
                {
                    return result > 0 && __testlib_isInfinite(result);
                }
                else
                {
                    return result < 0 && __testlib_isInfinite(result);
                }
            }
            else 
                if (__testlib_isNaN(result) || __testlib_isInfinite(result))
                {
                    return false;
                }
                else 
                if (__testlib_abs(result - expected) <= MAX_DOUBLE_ERROR + 1E-15)
                {
                    return true;
                }
                else
                {
                    double minv = __testlib_min(expected * (1.0 - MAX_DOUBLE_ERROR),
                                 expected * (1.0 + MAX_DOUBLE_ERROR));
                    double maxv = __testlib_max(expected * (1.0 - MAX_DOUBLE_ERROR),
                                  expected * (1.0 + MAX_DOUBLE_ERROR));
                    return result + 1E-15 >= minv && result <= maxv + 1E-15;
                }
}

#define _wa 0
#define _ok 100

#define quitf(score, ...) (printf("%d",score),fprintf(stderr,__VA_ARGS__),exit(0))

int main()
{
	FILE*fin=fopen("input","r");
	int T;
	fscanf(fin,"%d",&T);
	fclose(fin);
	
	FILE*fuser=fopen("user_out","r");
	FILE*fans=fopen("answer","r");
	for(int i=1;i<=T;i++){
		double ad, od;
		fscanf(fans,"%lf",&ad);
		fscanf(fuser,"%lf",&od);
		if (!doubleCompare(ad, od, EPS))
			quitf(_wa, "Expected %.10f, found %.10f", ad, od);
	}
	fclose(fans);fclose(fuser);
    
    quitf(_ok, "");
}
